/*
 * Decompiled with CFR 0.152.
 */
package jade.mtp.http;

import jade.domain.FIPAAgentManagement.Envelope;
import jade.mtp.http.HTTPAddress;
import jade.mtp.http.XMLCodec;
import jade.util.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class HTTPIO {
    public static final String OK = "200 OK";
    private static final String ERROR = "406 Not Acceptable";
    private static final String HTTP1 = "HTTP/1.";
    private static final byte[] PROXY = new byte[]{80, 114, 111, 120, 121, 45, 67, 111, 110, 110, 101, 99, 116, 105, 111, 110, 58, 32};
    private static final String PROXY_STR = "Proxy-Connection: ";
    private static final byte CR = 13;
    private static final byte LF = 10;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final byte[] POST = new byte[]{80, 79, 83, 84};
    private static final String POST_STR = "POST";
    private static final byte[] CONTENT = new byte[]{67, 111, 110, 116, 101, 110, 116, 45, 84, 121, 112, 101, 58, 32};
    private static final String CONTENT_STR = "Content-Type: ";
    private static final byte[] CLENGTH = new byte[]{67, 111, 110, 116, 101, 110, 116, 45, 76, 101, 110, 103, 116, 104, 58, 32};
    private static final byte[] MM = new byte[]{109, 117, 108, 116, 105, 112, 97, 114, 116, 47, 109, 105, 120, 101, 100};
    private static final String MM_STR = "multipart/mixed";
    private static final byte[] BND = new byte[]{98, 111, 117, 110, 100, 97, 114, 121};
    private static final String BND_STR = "boundary";
    private static final byte[] APPLI = new byte[]{97, 112, 112, 108, 105, 99, 97, 116, 105, 111, 110, 47};
    private static final byte[] CONN = new byte[]{67, 111, 110, 110, 101, 99, 116, 105, 111, 110, 58, 32};
    private static final String CONN_STR = "Connection: ";
    public static final String CLOSE = "close";
    public static final String KA = "Keep-Alive";
    private static final byte[] HTTP = new byte[]{72, 84, 84, 80, 47, 49, 46, 49};
    private static final byte[] CACHE = new byte[]{67, 97, 99, 104, 101, 45, 67, 111, 110, 116, 114, 111, 108, 58, 32, 110, 111, 45, 99, 97, 99, 104, 101};
    private static final byte[] MIME = new byte[]{77, 105, 109, 101, 45, 86, 101, 114, 115, 105, 111, 110, 58, 32, 49, 46, 48};
    private static final byte[] HOST = new byte[]{72, 111, 115, 116, 58, 32};
    private static final String HOST_STR = "Host: ";
    private static final byte[] DL = new byte[]{45, 45};
    private static final String DL_STR = "--";
    private static final String BLK = "";
    private static final byte[] MIME_MULTI_PART_HEADER = new byte[]{84, 104, 105, 115, 32, 105, 115, 32, 110, 111, 116, 32, 112, 97, 114, 116, 32, 111, 102, 32, 116, 104, 101, 32, 77, 73, 77, 69, 32, 109, 117, 108, 116, 105, 112, 97, 114, 116, 32, 101, 110, 99, 111, 100, 101, 100, 32, 109, 101, 115, 115, 97, 103, 101, 46};
    private static final byte[] XML = new byte[]{120, 109, 108};
    private static final byte[] CHARSET = new byte[]{59, 32, 99, 104, 97, 114, 115, 101, 116, 61};
    private static final byte[] TEXT = new byte[]{116, 101, 120, 116};
    private static final byte[] TEXT_HTML = new byte[]{116, 101, 120, 116, 47, 104, 116, 109, 108};
    private static final byte[] HTML_BEGIN = new byte[]{60, 104, 116, 109, 108, 62, 60, 98, 111, 100, 121, 62, 60, 104, 49, 62};
    private static final byte[] HTML_END = new byte[]{60, 47, 104, 49, 62, 60, 47, 98, 111, 100, 121, 62, 60, 47, 104, 116, 109, 108, 62};
    private static Logger logger = Logger.getMyLogger((class$jade$mtp$http$HTTPIO == null ? (class$jade$mtp$http$HTTPIO = HTTPIO.class$("jade.mtp.http.HTTPIO")) : class$jade$mtp$http$HTTPIO).getName());
    static /* synthetic */ Class class$jade$mtp$http$HTTPIO;

    public static void writeAll(OutputStream output, byte[] message) throws IOException {
        output.write(message);
        output.write(CRLF);
        output.flush();
    }

    public static byte[] createHTTPResponse(String msgCode, String type) {
        ByteArrayOutputStream message = new ByteArrayOutputStream(256);
        try {
            message.write(HTTP);
            message.write(32);
            HTTPIO.writeLowBytes(message, msgCode);
            message.write(CRLF);
            message.write(CONTENT);
            message.write(TEXT_HTML);
            message.write(CRLF);
            message.write(CACHE);
            message.write(CRLF);
            message.write(CONN);
            HTTPIO.writeLowBytes(message, type);
            message.write(CRLF);
            message.write(CRLF);
            message.write(HTML_BEGIN);
            HTTPIO.writeLowBytes(message, msgCode);
            message.write(HTML_END);
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return message.toByteArray();
    }

    public static byte[] createHTTPHeader(HTTPAddress host, int length, String policy, byte[] boundary, boolean proxy) {
        ByteArrayOutputStream header = new ByteArrayOutputStream(256);
        try {
            header.write(POST);
            header.write(32);
            HTTPIO.writeLowBytes(header, host.toString());
            header.write(32);
            header.write(HTTP);
            header.write(CRLF);
            header.write(CACHE);
            header.write(CRLF);
            header.write(MIME);
            header.write(CRLF);
            header.write(HOST);
            HTTPIO.writeLowBytes(header, host.getHost());
            header.write(58);
            HTTPIO.writeLowBytes(header, host.getPort());
            header.write(CRLF);
            header.write(CONTENT);
            header.write(MM);
            header.write(32);
            header.write(59);
            header.write(32);
            header.write(BND);
            header.write(61);
            header.write(34);
            header.write(boundary);
            header.write(34);
            header.write(CRLF);
            header.write(CLENGTH);
            HTTPIO.writeLowBytes(header, Integer.toString(length));
            header.write(CRLF);
            if (proxy) {
                header.write(PROXY);
                HTTPIO.writeLowBytes(header, policy);
                header.write(CRLF);
            } else {
                header.write(CONN);
                HTTPIO.writeLowBytes(header, policy);
                header.write(CRLF);
            }
            header.write(CRLF);
            header.flush();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return header.toByteArray();
    }

    public static byte[] createHTTPBody(Envelope env, byte[] boundary, byte[] payload) {
        ByteArrayOutputStream body = new ByteArrayOutputStream(payload.length + 100);
        try {
            body.write(MIME_MULTI_PART_HEADER);
            body.write(CRLF);
            body.write(DL);
            body.write(boundary);
            body.write(CRLF);
            body.write(CONTENT);
            body.write(APPLI);
            body.write(XML);
            body.write(CRLF);
            body.write(CRLF);
            env.setPayloadLength(new Long(payload.length));
            HTTPIO.writeLowBytes(body, XMLCodec.encodeXML(env));
            body.write(CRLF);
            body.write(DL);
            body.write(boundary);
            body.write(CRLF);
            String payloadEncoding = env.getPayloadEncoding();
            if (payloadEncoding != null && payloadEncoding.length() > 0) {
                body.write(CONTENT);
                HTTPIO.writeLowBytes(body, env.getAclRepresentation());
                body.write(CHARSET);
                HTTPIO.writeLowBytes(body, payloadEncoding);
            } else {
                body.write(CONTENT);
                body.write(APPLI);
                body.write(TEXT);
            }
            body.write(CRLF);
            body.write(CRLF);
            body.write(payload);
            body.write(CRLF);
            body.write(DL);
            body.write(boundary);
            body.write(DL);
            body.write(CRLF);
            body.flush();
        }
        catch (IOException exception) {
            exception.printStackTrace();
        }
        return body.toByteArray();
    }

    /*
     * Unable to fully structure code
     */
    public static String readAll(InputStream input, StringBuffer xml, OutputStream acl, StringBuffer type) throws IOException {
        host = null;
        foundBoundary = false;
        boundary = null;
        typeConnection = null;
        while ("".equals(line = HTTPIO.readLineFromInputStream(input))) {
        }
        if (line == null) {
            throw new IOException();
        }
        st = new StringTokenizer(line);
        try {
            if (!st.nextToken().equalsIgnoreCase("POST")) {
                if (HTTPIO.logger.isLoggable(Logger.WARNING)) {
                    HTTPIO.logger.log(Logger.WARNING, "Malformed POST");
                }
                type.append("close");
                return "406 Not Acceptable";
            }
            st.nextToken();
            if (!st.nextToken().toUpperCase().startsWith("HTTP/1.")) {
                if (HTTPIO.logger.isLoggable(Logger.WARNING)) {
                    HTTPIO.logger.log(Logger.WARNING, "Malformed HTTP/1.1 ");
                }
                type.append("close");
                return "406 Not Acceptable";
            }
            ** GOTO lbl55
        }
        catch (NoSuchElementException nsee) {
            if (HTTPIO.logger.isLoggable(Logger.WARNING)) {
                HTTPIO.logger.log(Logger.WARNING, "Malformed start line !: " + line);
            }
            type.append("close");
            return "406 Not Acceptable";
        }
lbl-1000:
        // 1 sources

        {
            lowerCaseLine = line.toLowerCase();
            if (lowerCaseLine.startsWith("Host: ".toLowerCase())) {
                host = HTTPIO.processLine(line);
            }
            if (lowerCaseLine.startsWith("Connection: ".toLowerCase())) {
                typeConnection = HTTPIO.processLine(line);
            }
            if (!lowerCaseLine.startsWith("Content-Type: ".toLowerCase())) continue;
            if (!HTTPIO.processLine(line).toLowerCase().startsWith("multipart/mixed")) {
                if (HTTPIO.logger.isLoggable(Logger.WARNING)) {
                    HTTPIO.logger.log(Logger.WARNING, "MULTIPART/MIXED");
                }
                type.append("close");
                return "406 Not Acceptable";
            }
            pos = line.indexOf("boundary");
            if (pos == -1 && (pos = (line = HTTPIO.readLineFromInputStream(input)).indexOf("boundary")) == -1) {
                if (HTTPIO.logger.isLoggable(Logger.WARNING)) {
                    HTTPIO.logger.log(Logger.WARNING, "MIME boundary not found");
                }
                type.append("close");
                return "406 Not Acceptable";
            }
            line = line.substring(pos + "boundary".length());
            pos = line.indexOf("\"") + 1;
            boundary = "--" + line.substring(pos, line.indexOf("\"", pos));
            foundBoundary = true;
lbl55:
            // 3 sources

            ** while (!"".equals((Object)(line = HTTPIO.readLineFromInputStream((InputStream)input))))
        }
lbl56:
        // 1 sources

        if (!foundBoundary) {
            if (HTTPIO.logger.isLoggable(Logger.WARNING)) {
                HTTPIO.logger.log(Logger.WARNING, "Mime header error");
            }
            type.append("close");
            return "406 Not Acceptable";
        }
        if (typeConnection == null) {
            type.append("Keep-Alive");
        } else {
            type.append(typeConnection);
        }
        while ("".equals(line = HTTPIO.readLineFromInputStream(input))) {
        }
        while (!line.startsWith(boundary) && !"".equals(line = HTTPIO.readLineFromInputStream(input))) {
        }
        while ("".equals(line = HTTPIO.readLineFromInputStream(input))) {
        }
        while (!line.toLowerCase().startsWith("Content-Type: ".toLowerCase()) && !"".equals(line = HTTPIO.readLineFromInputStream(input))) {
        }
        while (!boundary.equals(line = HTTPIO.readLineFromInputStream(input))) {
            if (line.equals("")) continue;
            xml.append(line);
        }
        while ("".equals(line = HTTPIO.readLineFromInputStream(input))) {
        }
        while (!line.toLowerCase().startsWith("Content-Type: ".toLowerCase()) && !"".equals(line = HTTPIO.readLineFromInputStream(input))) {
        }
        boundaryPattern = new ByteArrayOutputStream(boundary.length() + 6);
        boundaryPattern.write(HTTPIO.CRLF);
        boundaryPattern.write(boundary.getBytes("ISO-8859-1"));
        boundaryPattern.write(HTTPIO.DL);
        character = -1;
        while ((character = input.read()) == 13 || character == 10) {
        }
        if (character >= 0) {
            acl.write(character);
            HTTPIO.readBytesUpTo(input, acl, boundaryPattern.toByteArray());
        }
        return "200 OK";
    }

    public static int getResponseCode(InputStream input, StringBuffer type) throws IOException {
        int responseCode = -1;
        try {
            String line = null;
            while (!(line = HTTPIO.readLineFromInputStream(input)).startsWith(HTTP1)) {
            }
            responseCode = Integer.parseInt(HTTPIO.processLine(line));
            while ((line = HTTPIO.readLineFromInputStream(input)) != null && !line.equals(BLK)) {
                if (line.toLowerCase().startsWith(CONN_STR.toLowerCase())) {
                    type.append(HTTPIO.processLine(line));
                    continue;
                }
                if (!line.toLowerCase().startsWith(PROXY_STR.toLowerCase())) continue;
                type.append(HTTPIO.processLine(line));
            }
            if (type.length() == 0) {
                type.append(KA);
            }
            return responseCode;
        }
        catch (Exception e) {
            type.append(CLOSE);
            return responseCode;
        }
    }

    private static String processLine(String line) throws IOException {
        StringTokenizer st = new StringTokenizer(line);
        try {
            st.nextToken();
            return st.nextToken();
        }
        catch (NoSuchElementException nsee) {
            throw new IOException("Malformed line !: " + line);
        }
    }

    private static boolean readBytesUpTo(InputStream input, OutputStream output, byte[] pattern) throws IOException {
        if (pattern == null || pattern.length == 0) {
            throw new IllegalArgumentException("Specified pattern is null or empty.");
        }
        int patternIndex = 0;
        boolean matched = false;
        boolean atEnd = false;
        while (!matched && !atEnd) {
            int readByte = input.read();
            if (readByte < 0) {
                atEnd = true;
                if (patternIndex == 0) continue;
                output.write(pattern, 0, patternIndex);
                patternIndex = 0;
                continue;
            }
            if (readByte == pattern[patternIndex]) {
                if (++patternIndex < pattern.length) continue;
                matched = true;
                continue;
            }
            if (patternIndex != 0) {
                output.write(pattern, 0, patternIndex);
                patternIndex = 0;
            }
            output.write(readByte);
        }
        return matched;
    }

    /*
     * WARNING - void declaration
     */
    private static String readLineFromInputStream(InputStream input) throws IOException {
        int characterByte;
        StringBuffer buffer = new StringBuffer(256);
        boolean justBeforeCR = false;
        boolean terminated = false;
        boolean entered = false;
        while (!terminated && (characterByte = input.read()) >= 0) {
            void var2_5;
            entered = true;
            switch (var2_5) {
                case 13: {
                    if (justBeforeCR) {
                        buffer.append('\r');
                        break;
                    }
                    justBeforeCR = true;
                    break;
                }
                case 10: {
                    if (justBeforeCR) {
                        terminated = true;
                    } else {
                        buffer.append('\n');
                    }
                    justBeforeCR = false;
                    break;
                }
                default: {
                    if (justBeforeCR) {
                        buffer.append('\r');
                    }
                    buffer.append((char)var2_5);
                    justBeforeCR = false;
                }
            }
        }
        if (!entered) {
            return null;
        }
        if (!terminated && justBeforeCR) {
            buffer.append('\r');
        }
        return buffer.toString();
    }

    private static void writeLowBytes(OutputStream output, String string) throws IOException {
        int i = 0;
        while (i < string.length()) {
            output.write(string.charAt(i));
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

